<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ProductionUnit;
use App\Warehouse;


class ProductionLineController extends Controller
{
    public function __construct()
    {
        $data['qty'] = 0;
        $all = \App\Product_Warehouse::where('qty',"<",0)->update($data);
        $all = \App\Product::where('qty',"<",0)->update($data);

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->input('warehouse_id'))
            $warehouse_id = $request->input('warehouse_id');
        else
            $warehouse_id = 0;


        if($request->input('starting_date')) {
            $starting_date = $request->input('starting_date');
            $ending_date = $request->input('ending_date');
        }
        else {
            $starting_date = date("Y-m-d", strtotime(date('Y-m-d', strtotime('-1 year', strtotime(date('Y-m-d') )))));
            $ending_date = date("Y-m-d");
        }



        if ($request->has('starting_date') &&
            $request->has('ending_date') &&
            $request->has('warehouse_id') ){

            if ($request->warehouse_id != 0){
                $lims_productionUnit_data = ProductionUnit::with('product','warehouse')
                    ->where('warehouse_id',$warehouse_id)
                    ->whereDate('created_at', '>=' ,$request->input('starting_date'))
                    ->whereDate('created_at', '<=' ,$request->input('ending_date'))
                    ->orderby('id','DESC')->get();
            }else{
                $lims_productionUnit_data = ProductionUnit::with('product','warehouse')
                    ->whereDate('created_at', '>=' ,$request->input('starting_date'))
                    ->whereDate('created_at', '<=' ,$request->input('ending_date'))
                    ->orderby('id','DESC')->get();
            }

        }else{

            $lims_productionUnit_data = ProductionUnit::with('product','warehouse')
                ->orderby('id','DESC')->get();
        }
        $lims_warehouse_list = Warehouse::where('is_active',true)
            ->latest()->get();





        return view('productionLine/index',compact('lims_productionUnit_data',
            'starting_date','ending_date','warehouse_id','lims_warehouse_list'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
