<?php

namespace NumberToWords\NumberTransformer;

class FrenchNumberTransformerTest extends NumberTransformerTest
{
    public function setUp()
    {
        $this->numberTransformer = new FrenchNumberTransformer();
    }

    public function providerItConvertsNumbersToWords()
    {
        return [
            [-999, 'moins neuf cent quatre-vingt-dix-neuf'],
            [0, 'zéro'],
            [1, 'un'],
            [2, 'deux'],
            [3, 'trois'],
            [4, 'quatre'],
            [5, 'cinq'],
            [6, 'six'],
            [7, 'sept'],
            [8, 'huit'],
            [9, 'neuf'],
            [9, 'neuf'],
            [10, 'dix'],
            [11, 'onze'],
            [12, 'douze'],
            [16, 'seize'],
            [19, 'dix-neuf'],
            [20, 'vingt'],
            [21, 'vingt et un'],
            [25, 'vingt-cinq'],
            [26, 'vingt-six'],
            [30, 'trente'],
            [31, 'trente et un'],
            [40, 'quarante'],
            [43, 'quarante-trois'],
            [50, 'cinquante'],
            [55, 'cinquante-cinq'],
            [58, 'cinquante-huit'],
            [60, 'soixante'],
            [67, 'soixante-sept'],
            [70, 'soixante-dix'],
            [71, 'soixante et onze'],
            [72, 'soixante-douze'],
            [79, 'soixante-dix-neuf'],
            [80, 'quatre-vingts'],
            [81, 'quatre-vingt-un'],
            [82, 'quatre-vingt-deux'],
            [90, 'quatre-vingt-dix'],
            [91, 'quatre-vingt-onze'],
            [92, 'quatre-vingt-douze'],
            [99, 'quatre-vingt-dix-neuf'],
            [100, 'cent'],
            [101, 'cent un'],
            [102, 'cent deux'],
            [111, 'cent onze'],
            [113, 'cent treize'],
            [120, 'cent vingt'],
            [121, 'cent vingt et un'],
            [199, 'cent quatre-vingt-dix-neuf'],
            [203, 'deux cent trois'],
            [229, 'deux cent vingt-neuf'],
            [287, 'deux cent quatre-vingt-sept'],
            [300, 'trois cents'],
            [356, 'trois cent cinquante-six'],
            [410, 'quatre cent dix'],
            [434, 'quatre cent trente-quatre'],
            [500, 'cinq cents'],
            [578, 'cinq cent soixante-dix-huit'],
            [660, 'six cent soixante'],
            [666, 'six cent soixante-six'],
            [689, 'six cent quatre-vingt-neuf'],
            [729, 'sept cent vingt-neuf'],
            [894, 'huit cent quatre-vingt-quatorze'],
            [900, 'neuf cents'],
            [909, 'neuf cent neuf'],
            [919, 'neuf cent dix-neuf'],
            [990, 'neuf cent quatre-vingt-dix'],
            [999, 'neuf cent quatre-vingt-dix-neuf'],
            [1000, 'mille'],
            [1001, 'mille un'],
            [1010, 'mille dix'],
            [1015, 'mille quinze'],
            [1097, 'mille quatre-vingt-dix-sept'],
            [1100, 'mille cent'],
            [1104, 'mille cent quatre'],
            [1111, 'mille cent onze'],
            [1243, 'mille deux cent quarante-trois'],
            [2000, 'deux mille'],
            [2385, 'deux mille trois cent quatre-vingt-cinq'],
            [3766, 'trois mille sept cent soixante-six'],
            [4000, 'quatre mille'],
            [4196, 'quatre mille cent quatre-vingt-seize'],
            [4538, 'quatre mille cinq cent trente-huit'],
            [5000, 'cinq mille'],
            [5020, 'cinq mille vingt'],
            [5846, 'cinq mille huit cent quarante-six'],
            [6459, 'six mille quatre cent cinquante-neuf'],
            [7232, 'sept mille deux cent trente-deux'],
            [8569, 'huit mille cinq cent soixante-neuf'],
            [9539, 'neuf mille cinq cent trente-neuf'],
            [11000, 'onze mille'],
            [11001, 'onze mille un'],
            [21000, 'vingt et un mille'],
            [21512, 'vingt et un mille cinq cent douze'],
            [90000, 'quatre-vingt-dix mille'],
            [92100, 'quatre-vingt-douze mille cent'],
            [212112, 'deux cent douze mille cent douze'],
            [720018, 'sept cent vingt mille dix-huit'],
            [999000, 'neuf cent quatre-vingt-dix-neuf mille'],
            [999999, 'neuf cent quatre-vingt-dix-neuf mille neuf cent quatre-vingt-dix-neuf'],
            [1000000, 'un million'],
            [1001001, 'un million mille un'],
            [2000000, 'deux millions'],
            [3248518, 'trois millions deux cent quarante-huit mille cinq cent dix-huit'],
            [4000000, 'quatre millions'],
            [5000000, 'cinq millions'],
            [999000000, 'neuf cent quatre-vingt-dix-neuf millions'],
            [999000999, 'neuf cent quatre-vingt-dix-neuf millions neuf cent quatre-vingt-dix-neuf'],
            [999999000, 'neuf cent quatre-vingt-dix-neuf millions neuf cent quatre-vingt-dix-neuf mille'],
            [999999999, 'neuf cent quatre-vingt-dix-neuf millions neuf cent quatre-vingt-dix-neuf mille neuf cent quatre-vingt-dix-neuf'],
            [1174315110, 'un milliard cent soixante-quatorze millions trois cent quinze mille cent dix'],
            [1174315119, 'un milliard cent soixante-quatorze millions trois cent quinze mille cent dix-neuf'],
            [1800000006, 'un milliard huit cents millions six'],
            [15174315119, 'quinze milliards cent soixante-quatorze millions trois cent quinze mille cent dix-neuf'],
            [35174315119, 'trente-cinq milliards cent soixante-quatorze millions trois cent quinze mille cent dix-neuf'],
            [935174315119, 'neuf cent trente-cinq milliards cent soixante-quatorze millions trois cent quinze mille cent dix-neuf'],
            [2935174315119, 'deux billions neuf cent trente-cinq milliards cent soixante-quatorze millions trois cent quinze mille cent dix-neuf'],
        ];
    }
}
